import UIKit

class ViewController: UIViewController, CAAnimationDelegate
{
    @IBOutlet weak var redBox: UIView!
    @IBOutlet weak var one: UILabel!
    @IBOutlet weak var two: UILabel!
    @IBOutlet weak var three: UILabel!
    @IBOutlet weak var four: UILabel!

    var positionArr : Array <CGPoint> = []
    
    override func viewDidAppear(_ animated: Bool)
    {
        super.viewDidAppear(true)
        positionArr = [one.center, two.center, three.center, four.center]
        redBox.center = positionArr[0]
    }

    @IBAction func animeAction(_ sender: Any)
    {
        let anime = CAKeyframeAnimation (keyPath: #keyPath (CALayer.position))
        
        let timesArr = [0.0, 0.8, 0.9, 1.0]
        
        anime.values = positionArr
        anime.keyTimes = timesArr as [NSNumber]
        anime.duration = 5.0
        anime.calculationMode = CAAnimationCalculationMode.cubic
        
        anime.delegate = self
        
        redBox.layer.add(anime,
                         forKey: "myAnime")
    }
    
    
    func animationDidStop(_ anim: CAAnimation,
                          finished flag: Bool)
    {
        redBox.center = positionArr[positionArr.count - 1]
    }
    
}

